using System;
using System.Collections.Generic;
using System.Text;

namespace Inheritance
{
   public abstract class Animal
   {
      private string color;

      public Animal()
      {
         color = "Niebieski";
      }

      public virtual void MakeNoise()
      {
         Console.WriteLine("Cos przypominajacego ryk!");
      }

      public string Color
      {
         get { return color; }
         set { color = value; }
      }
   }

   public class Cat : Animal
   {
      public Cat()
         : base()
      {
         Color = "Czarny";
      }

      public new void MakeNoise()
      {
         Console.WriteLine("Zamiauczal.");
      }
   }

   public class Lion : Cat
   {
      public Lion()
         : base()
      {
         Color = "Zlty";
      }

      public new virtual void MakeNoise()
      {
         Console.WriteLine("ROOooWWRrrRR!!");
      }

   }


   public class ReallyBigLion : Lion
   {
      public ReallyBigLion()
         : base()
      {
         Color = "BrightRed";
      }

      public override void MakeNoise()
      {
         Console.WriteLine("BARDZO GLOSNY RYK.");
      }
   }


   class Program
   {
      static void Main(string[] args)
      {
         Cat c = new Cat();

         Lion l = new Lion();

         Cat polyCat = (Cat)l;
         polyCat.MakeNoise();

         ReallyBigLion rbl = new ReallyBigLion();
         rbl.MakeNoise();
         Lion polyLion = (Lion)rbl;
         polyLion.MakeNoise();
         polyCat = (Cat)rbl;
         polyCat.MakeNoise();

      }
   }
}
